#include "operatingsystem.h"
#include "c4d_basebitmap.h"
#include "c4d_memory.h"
#include "c4d_file.h"
#include "c4d_basecontainer.h"

BaseBitmap *BaseBitmap::Alloc(void)
{
	return C4DOS.Bm->Alloc();
}

void BaseBitmap::Free(BaseBitmap *&bm)
{
	C4DOS.Bm->Free(bm);
	bm=NULL;
}

BaseBitmap *BaseBitmap::GetClone(void) 
{
	return C4DOS.Bm->GetClone(this);
}

Bool BaseBitmap::CopyTo(BaseBitmap *dst) 
{
	return C4DOS.Bm->CopyTo(this,dst);
}

BaseBitmap *BaseBitmap::GetClonePart(LONG x, LONG y, LONG w, LONG h) 
{
	return C4DOS.Bm->GetClonePart(this,x,y,w,h);
}

void BaseBitmap::FlushAll(void)
{
	C4DOS.Bm->FlushAll(this);
}
		
LONG BaseBitmap::Init(LONG x, LONG y, LONG depth)
{
	return C4DOS.Bm->Init1(this,x,y,depth);
}

LONG BaseBitmap::Init(const Filename &name, LONG frame, Bool *ismovie)
{
	return C4DOS.Bm->Init2(this,&name,frame,ismovie);
}

LONG BaseBitmap::Save(const Filename &name, LONG format, BaseContainer *data, LONG savebits)
{
	return C4DOS.Bm->Save(this,&name,format,data,savebits);
}

void BaseBitmap::SetPixelCnt(LONG x, LONG y, LONG cnt, UCHAR *buffer, LONG inc)
{
	C4DOS.Bm->SetPixelCnt(this,x,y,cnt,buffer,inc);
}

void BaseBitmap::GetPixelCnt(LONG x, LONG y, LONG cnt, UCHAR *buffer, LONG inc)
{
	C4DOS.Bm->GetPixelCnt(this,x,y,cnt,buffer,inc);
}

void BaseBitmap::GetLine(LONG y, void *data)
{
	C4DOS.Bm->GetLine(this,y,data);
}

void BaseBitmap::SetLine(LONG y, void *data, LONG depth)
{
	C4DOS.Bm->SetLine(this,y,data,depth);
}

void BaseBitmap::GetAlphaLine(LONG y, void *data, LONG channel)
{
	C4DOS.Bm->GetAlphaLine(this,y,data,channel);
}

void BaseBitmap::SetAlphaLine(LONG y, void *data, LONG channel)
{
	C4DOS.Bm->SetAlphaLine(this,y,data,channel);
}

void BaseBitmap::SetCMAP(LONG i, LONG r, LONG g, LONG b)
{
	C4DOS.Bm->SetCMAP(this,i,r,g,b);
}

void BaseBitmap::ScaleIt(BaseBitmap *dst, LONG intens, Bool sample, Bool nprop)
{
	C4DOS.Bm->ScaleIt(this,dst,intens,sample,nprop);
}

void BaseBitmap::Clear(LONG r, LONG g, LONG b)
{
	C4DOS.Bm->Clear(this,0,0,GetBw()-1,GetBh()-1,r,g,b);
}

void BaseBitmap::Clear(LONG x1, LONG y1, LONG x2, LONG y2, LONG r, LONG g, LONG b)
{
	C4DOS.Bm->Clear(this,x1,y1,x2,y2,r,g,b);
}

LONG BaseBitmap::AddChannel(Bool internal, Bool straight)
{
	return C4DOS.Bm->AddChannel(this,internal,straight);
}

void BaseBitmap::RemoveChannel(LONG channel)
{
	C4DOS.Bm->RemoveChannel(this,channel);
}

LONG BaseBitmap::GetInternalChannel(void)
{
	return C4DOS.Bm->GetInternalChannel(this);
}

LONG BaseBitmap::GetChannelCount(void)
{
	return C4DOS.Bm->GetChannelCount(this);
}

LONG BaseBitmap::GetChannelNum(LONG num)
{
	return C4DOS.Bm->GetChannelNum(this,num);
}

LONG BaseBitmap::SaveChannel(LONG channel, const Filename &name)
{
	return C4DOS.Bm->SaveChannel(this,channel,&name);
}

MovieSaver *MovieSaver::Alloc(void)
{
	return C4DOS.Ms->Alloc();
}

void MovieSaver::Free(MovieSaver *&ms)
{
	C4DOS.Ms->Free(ms);
	ms=NULL;
}

LONG MovieSaver::Open(const Filename &name, BaseBitmap *bm, LONG fps, LONG id, BaseContainer *data, LONG savebits)
{
	return C4DOS.Ms->Open(this,&name,bm,fps,id,data,savebits);
}

LONG MovieSaver::Write(BaseBitmap *bm)
{
	return C4DOS.Ms->Write(this,bm);
}

void MovieSaver::Close(void)
{
	C4DOS.Ms->Close(this);
}

Bool MovieSaver::Choose(LONG id, BaseContainer *bc)
{
	return C4DOS.Ms->Choose(this,id,bc);
}
